
import gurobipy as gp

# Create a new model
model = gp.Model("aquarium_diet")

# Create variables
sardines = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sardines")
tuna = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tuna")

# Set objective function
model.setObjective(15 * sardines + 18 * tuna, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * sardines + 6 * tuna >= 800, "fat")
model.addConstr(12 * sardines + 10 * tuna >= 1200, "efa")
model.addConstr(10 * sardines + 7 * tuna >= 700, "protein")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${model.objVal}")
    print(f"Number of sardine packets: {sardines.x}")
    print(f"Number of tuna packets: {tuna.x}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

