
from gurobipy import *

# Create a new model
m = Model("Aquarium_Feeding")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="sardines", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="tuna", lb=0)

# Set the objective function
m.setObjective(15*x1 + 18*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x1 + 6*x2 >= 800, "fat_requirement")
m.addConstr(12*x1 + 10*x2 >= 1200, "essential_fatty_acids_requirement")
m.addConstr(10*x1 + 7*x2 >= 700, "protein_requirement")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of packets of sardines: {x1.x}")
    print(f"Number of packets of tuna: {x2.x}")
    print(f"Total cost: {m.objVal}")
else:
    print("No optimal solution found")
