
import gurobi

def solve_aquarium_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="sardines", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="tuna", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define the objective function
    model.setObjective(15*x1 + 18*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(4*x1 + 6*x2 >= 800, name="fat_constraint")
    model.addConstr(12*x1 + 10*x2 >= 1200, name="essential_fatty_acids_constraint")
    model.addConstr(10*x1 + 7*x2 >= 700, name="protein_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Packets of sardines: {x1.varValue}")
        print(f"Packets of tuna: {x2.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_aquarium_problem()
