
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("investment_problem")

# Create variables
gold = m.addVar(vtype=GRB.CONTINUOUS, name="gold")
diamond = m.addVar(vtype=GRB.CONTINUOUS, name="diamond")
ruby = m.addVar(vtype=GRB.CONTINUOUS, name="ruby")
sapphire = m.addVar(vtype=GRB.CONTINUOUS, name="sapphire")


# Set objective function
m.setObjective(0.03 * gold + 0.05 * diamond + 0.06 * ruby + 0.1 * sapphire, GRB.MAXIMIZE)

# Add constraints
m.addConstr(gold + diamond + ruby + sapphire <= 1000000, "total_investment")
m.addConstr(sapphire <= gold, "sapphire_gold")
m.addConstr(diamond <= ruby, "diamond_ruby")
m.addConstr(sapphire <= 0.4 * 1000000, "sapphire_max")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Gold: ${gold.x:.2f}")
    print(f"Invest in Diamond: ${diamond.x:.2f}")
    print(f"Invest in Ruby: ${ruby.x:.2f}")
    print(f"Invest in Sapphire: ${sapphire.x:.2f}")

elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
    m.computeIIS()
    m.write("model.ilp")
    print("See model.ilp for an Irreducible Inconsistent Subsystem (IIS).")
else:
    print(f"Optimization terminated with status {m.status}")

