
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="gold", lb=0)
    x2 = model.addVar(name="diamond", lb=0)
    x3 = model.addVar(name="ruby", lb=0)
    x4 = model.addVar(name="sapphire", lb=0)

    # Objective function
    model.setObjective(0.03 * x1 + 0.05 * x2 + 0.06 * x3 + 0.10 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 1000000)
    model.addConstr(x4 <= x1)
    model.addConstr(x2 <= x3)
    model.addConstr(x4 <= 400000)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment:")
        print(f"Gold: ${x1.varValue}")
        print(f"Diamond: ${x2.varValue}")
        print(f"Ruby: ${x3.varValue}")
        print(f"Sapphire: ${x4.varValue}")
        print(f"Max Return: {model.objVal}")
    else:
        print("The model is infeasible")

solve_investment_problem()
