
import gurobipy as gp

# Create a new model
m = gp.Model("puzzle_optimization")

# Create variables
easy_puzzles = m.addVar(vtype=gp.GRB.INTEGER, name="easy_puzzles")
hard_puzzles = m.addVar(vtype=gp.GRB.INTEGER, name="hard_puzzles")

# Set objective function
m.setObjective(5 * easy_puzzles + 8 * hard_puzzles, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(easy_puzzles >= 3, "min_easy")
m.addConstr(hard_puzzles >= 1, "min_hard")
m.addConstr(easy_puzzles <= 10, "max_easy")
m.addConstr(hard_puzzles <= 5, "max_hard")
m.addConstr(easy_puzzles + hard_puzzles <= 10, "total_puzzles")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: {m.objVal} points")
    print(f"Solve {easy_puzzles.x} easy puzzles")
    print(f"Solve {hard_puzzles.x} hard puzzles")
elif m.status == gp.GRB.INFEASIBLE:
    print("Infeasible solution")
else:
    print("Optimization terminated with status:", m.status)

