
from gurobipy import *

# Create a model
m = Model("Puzzle Optimization")

# Define variables
x1 = m.addVar(lb=3, ub=10, vtype=GRB.INTEGER, name="easy_puzzles")
x2 = m.addVar(lb=1, ub=5, vtype=GRB.INTEGER, name="hard_puzzles")

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 10, "total_puzzles")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Easy puzzles: {x1.x}")
    print(f"Hard puzzles: {x2.x}")
    print(f"Total points: {5*x1.x + 8*x2.x}")
else:
    print("No optimal solution found")
