
import gurobi

def solve_puzzle_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, ub=10, vtype=gurobi.GRB.INTEGER, name="easy_puzzles")
    x2 = model.addVar(lb=0, ub=5, vtype=gurobi.GRB.INTEGER, name="hard_puzzles")

    # Objective function: maximize 5*x1 + 8*x2
    model.setObjective(5*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 >= 3, name="min_easy")
    model.addConstr(x2 >= 1, name="min_hard")
    model.addConstr(x1 <= 10, name="max_easy")
    model.addConstr(x2 <= 5, name="max_hard")
    model.addConstr(x1 + x2 <= 10, name="total_max")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution:")
        print(f"Easy puzzles: {x1.varValue}")
        print(f"Hard puzzles: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found")

solve_puzzle_problem()
