
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_production")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="standing_table")  # Number of standing tables
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="dining_table")  # Number of dining tables


# Set objective function
m.setObjective(45 * x1 + 95 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2 * x1 + 4 * x2 <= 6000, "parts_production")
m.addConstr(2.5 * x1 + 1 * x2 <= 3000, "assembly")
m.addConstr(2 * x1 + 1.5 * x2 <= 4500, "polishing")
m.addConstr(x1 >= 0, "nonnegativity_x1")
m.addConstr(x2 >= 0, "nonnegativity_x2")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of standing tables: {x1.x:.2f}")
    print(f"Number of dining tables: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

