
from gurobipy import *

# Create a new model
m = Model("Furniture_Maker_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="standing_tables")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="dining_tables")

# Set the objective function
m.setObjective(45*x1 + 95*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 4*x2 <= 6000, "parts_production")
m.addConstr(2.5*x1 + x2 <= 3000, "assembling")
m.addConstr(2*x1 + 1.5*x2 <= 4500, "polishing")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of standing tables: {x1.x}")
    print(f"Number of dining tables: {x2.x}")
    print(f"Total profit: ${45*x1.x + 95*x2.x:.2f}")
else:
    print("No optimal solution found")
