
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="standing_tables")
    x2 = model.addVar(lb=0, name="dining_tables")

    # Define the objective function
    model.setObjective(45 * x1 + 95 * x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(2 * x1 + 4 * x2 <= 6000, name="parts_production")
    model.addConstr(2.5 * x1 + x2 <= 3000, name="parts_assembly")
    model.addConstr(2 * x1 + 1.5 * x2 <= 4500, name="tables_polishing")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of standing tables: {x1.varValue}")
        print(f"Number of dining tables: {x2.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
