
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wood_shop")

# Create variables
canoes = m.addVar(vtype=GRB.CONTINUOUS, name="canoes")
paddles = m.addVar(vtype=GRB.CONTINUOUS, name="paddles")

# Set objective function
m.setObjective(500 * canoes + 75 * paddles, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * canoes + 0.5 * paddles <= 80, "cutting")
m.addConstr(5 * canoes + 1 * paddles <= 100, "woodworking")
m.addConstr(2 * canoes + 0.75 * paddles <= 70, "sanding")
m.addConstr(canoes >= 0, "canoes_non_negative")  # Ensure non-negativity
m.addConstr(paddles >= 0, "paddles_non_negative") # Ensure non-negativity


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of canoes to make: {canoes.x:.2f}")
    print(f"Number of paddles to make: {paddles.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

