
from gurobipy import *

# Create a new model
model = Model("Wood Shop Optimization")

# Define the variables
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="canoes", lb=0)
x2 = model.addVar(vtype=GRB.CONTINUOUS, name="paddles", lb=0)

# Set the objective function
model.setObjective(500*x1 + 75*x2, GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + 0.5*x2 <= 80, "cutting")
model.addConstr(5*x1 + x2 <= 100, "woodworking")
model.addConstr(2*x1 + 0.75*x2 <= 70, "sanding")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Canoes: {x1.x}")
    print(f"Paddles: {x2.x}")
    print(f"Maximum Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found")
