
import gurobipy as gp

# Create a new model
model = gp.Model("Canoe_and_Paddle_Production")

# Define the variables
x1 = model.addVar(name="canoes", lb=0, vtype=gp.GRB.INTEGER)  # Canoes
x2 = model.addVar(name="paddles", lb=0, vtype=gp.GRB.INTEGER)  # Paddles

# Define the objective function
model.setObjective(500*x1 + 75*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 + 0.5*x2 <= 80, name="cutting_constraint")  # Cutting constraint
model.addConstr(5*x1 + x2 <= 100, name="woodworking_constraint")  # Woodworking constraint
model.addConstr(2*x1 + 0.75*x2 <= 70, name="sanding_constraint")  # Sanding constraint

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Canoes = {x1.varValue}, Paddles = {x2.varValue}")
    print(f"Maximum profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
