
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("cruise_ship_optimization")

# Create variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="single_rooms") # number of single rooms
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="couple_rooms") # number of couple rooms

# Set objective function
m.setObjective(200*x1 + 1200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 800, "total_rooms")
m.addConstr(x1 >= 125, "min_single_rooms")
m.addConstr(x1 <= x2, "couple_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Single Rooms: {x1.x}")
    print(f"Number of Couple Rooms: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

