
from gurobipy import *

# Create a new model
m = Model("Cruise_Ship_Profit")

# Define variables
x1 = m.addVar(name="single_rooms", vtype=GRB.INTEGER, lb=0)
x2 = m.addVar(name="couple_rooms", vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(200*x1 + 1200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 800, name="total_rooms")
m.addConstr(x1 >= 125, name="single_room_minimum")
m.addConstr(2*x2 >= 2*x1, name="couple_preference")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Single rooms: {x1.x}")
    print(f"Couple's rooms: {x2.x}")
    print(f"Maximum profit: ${200*x1.x + 1200*x2.x}")
else:
    print("No optimal solution found")
