
import gurobipy as gp

# Create a new model
m = gp.Model("CruiseShip")

# Define variables
x1 = m.addVar(name="x1", lb=0, ub=800, vtype=gp.GRB.INTEGER)  # single rooms
x2 = m.addVar(name="x2", lb=0, ub=800, vtype=gp.GRB.INTEGER)  # couple's rooms

# Objective function: Maximize profit
m.setObjective(200*x1 + 1200*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 <= 800, name="total_rooms")
m.addConstr(x1 >= 125, name="min_single_rooms")
m.addConstr(x2 >= x1, name="couple_to_single_ratio")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: ${200*x1.varValue + 1200*x2.varValue}")
else:
    print("No optimal solution found")
