
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("hedge_fund_investment")

# Create variables
stocks = m.addVar(lb=0, name="stocks")
options = m.addVar(lb=0, name="options")
security_swaps = m.addVar(lb=0, name="security_swaps")
futures = m.addVar(lb=0, name="futures")

# Set objective function
m.setObjective(0.11 * stocks + 0.30 * options + 0.05 * security_swaps + 0.15 * futures, GRB.MAXIMIZE)

# Add constraints
m.addConstr(futures <= stocks, "futures_vs_stocks")
m.addConstr(futures <= 0.35 * (stocks + options + security_swaps + futures), "futures_percentage")
m.addConstr(options <= security_swaps, "options_vs_security_swaps")
m.addConstr(stocks + options + security_swaps + futures <= 3200000, "total_investment")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal annual return: ${m.objVal:.2f}")
    print(f"Invest ${stocks.x:.2f} in stocks")
    print(f"Invest ${options.x:.2f} in options")
    print(f"Invest ${security_swaps.x:.2f} in security swaps")
    print(f"Invest ${futures.x:.2f} in futures")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

