
import gurobi

def solve_hedge_fund_investment():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="stocks", lb=0)
    x2 = model.addVar(name="options", lb=0)
    x3 = model.addVar(name="security_swaps", lb=0)
    x4 = model.addVar(name="futures", lb=0)

    # Objective function: maximize return
    model.setObjective(0.11*x1 + 0.30*x2 + 0.05*x3 + 0.15*x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 3200000, name="total_investment")
    model.addConstr(x4 <= x1, name="futures_vs_stocks")
    model.addConstr(x4 <= 1120000, name="futures_limit")
    model.addConstr(x2 <= x3, name="options_vs_swaps")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Stocks: {x1.varValue}")
        print(f"Options: {x2.varValue}")
        print(f"Security Swaps: {x3.varValue}")
        print(f"Futures: {x4.varValue}")
        print(f"Max Return: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_hedge_fund_investment()
