
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Adrian's Diet")

# Create variables
bagels = m.addVar(vtype=GRB.CONTINUOUS, name="bagels")
burgers = m.addVar(vtype=GRB.CONTINUOUS, name="burgers")


# Set objective function
m.setObjective(4.5 * bagels + 12 * burgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(250 * bagels + 800 * burgers >= 2500, "Calorie Constraint")
m.addConstr(15 * bagels + 23.5 * burgers >= 500, "Fat Constraint")
m.addConstr(bagels >=0)
m.addConstr(burgers >=0)



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Cost: ${m.objVal:.2f}")
    print(f"Number of Bagels: {bagels.x:.2f}")
    print(f"Number of Burgers: {burgers.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

