
from gurobipy import *

# Create a new model
m = Model("Adrian_Diet")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="bagels")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="burgers")

# Set the objective function
m.setObjective(4.5*x1 + 12*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(250*x1 + 800*x2 >= 2500, "calories")
m.addConstr(15*x1 + 23.5*x2 >= 500, "fat")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagels: {x1.x}")
    print(f"Burgers: {x2.x}")
    print(f"Total cost: ${4.5*x1.x + 12*x2.x:.2f}")
else:
    print("No optimal solution found")
