
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bagels", lb=0)  # Number of bagels
    x2 = model.addVar(name="burgers", lb=0)  # Number of burgers

    # Define the objective function
    model.setObjective(4.5 * x1 + 12 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(250 * x1 + 800 * x2 >= 2500, name="calories_constraint")
    model.addConstr(15 * x1 + 23.5 * x2 >= 500, name="fat_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal number of bagels: {x1.varValue}")
        print(f"Optimal number of burgers: {x2.varValue}")
        print(f"Optimal cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
