
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_profit")

# Create variables
bookcases = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases")
computer_desks = m.addVar(vtype=GRB.CONTINUOUS, name="computer_desks")

# Set objective function
m.setObjective(500 * bookcases + 80 * computer_desks, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * bookcases + 5 * computer_desks <= 1000, "space")
m.addConstr(computer_desks >= 0.65 * (bookcases + computer_desks), "demand")
m.addConstr(1200 * bookcases + 200 * computer_desks <= 22000, "capital")
m.addConstr(bookcases >= 0, "non_negativity_bookcases")  # Explicit non-negativity constraints
m.addConstr(computer_desks >= 0, "non_negativity_computer_desks")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Number of bookcases: {bookcases.x}")
    print(f"Number of computer desks: {computer_desks.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

