
from gurobipy import *

# Create a new model
m = Model("Furniture_Optimization")

# Define variables
x1 = m.addVar(name="bookcases", lb=0)
x2 = m.addVar(name="computer_desks", lb=0)

# Set the objective function
m.setObjective(500*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 5*x2 <= 1000, name="space_constraint")
m.addConstr(x2 >= 0.65*(x1 + x2), name="quantity_constraint")
m.addConstr(1200*x1 + 200*x2 <= 22000, name="capital_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bookcases: {x1.x}")
    print(f"Number of computer desks: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
