
import gurobi

def solve_furniture_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="bookcase", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="computer desk", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(500 * x1 + 80 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12 * x1 + 5 * x2 <= 1000, name="space_constraint")
    model.addConstr(-0.65 * x1 + 0.35 * x2 >= 0, name="product_mix_constraint")
    model.addConstr(1200 * x1 + 200 * x2 <= 22000, name="capital_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bookcases: {x1.varValue}")
        print(f"Computer Desks: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_furniture_problem()
