
from gurobipy import *

# Create a new model
m = Model("Vaccine_Investment")

# Define variables
x1 = m.addVar(lb=0, name="Investment_in_M")
x2 = m.addVar(lb=0, name="Investment_in_P")

# Set the objective function
m.setObjective(0.09*x1 + 0.12*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 100000, "Total_Investment")
m.addConstr(x1 >= 3*x2, "Minimum_M_to_P_Ratio")
m.addConstr(x1 <= 80000, "Maximum_in_M")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Investment in Company M: ${x1.x:.2f}")
    print(f"Investment in Company P: ${x2.x:.2f}")
    print(f"Maximum Earnings: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
