
import gurobi

def solve_vaccine_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="investment_in_M", lb=0)
    x2 = model.addVar(name="investment_in_P", lb=0)

    # Objective function: maximize 0.09*x1 + 0.12*x2
    model.setObjective(0.09*x1 + 0.12*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100000, name="total_investment")
    model.addConstr(x1 >= 3*x2, name="M_to_P_ratio")
    model.addConstr(x1 <= 80000, name="max_investment_in_M")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in M: {x1.varValue}")
        print(f"Optimal investment in P: {x2.varValue}")
        print(f"Max earnings: {0.09*x1.varValue + 0.12*x2.varValue}")
    else:
        print("The model is infeasible")

solve_vaccine_investment_problem()
