
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("soup_kitchen")

# Create variables
individual_servings = m.addVar(vtype=GRB.INTEGER, name="individual_servings")
family_servings = m.addVar(vtype=GRB.INTEGER, name="family_servings")

# Set objective function
m.setObjective(3 * individual_servings + 10 * family_servings, GRB.MAXIMIZE)

# Add constraints
m.addConstr(250 * individual_servings + 1200 * family_servings <= 50000, "soup_limit")
m.addConstr(individual_servings >= 3 * family_servings, "individual_to_family_ratio")
m.addConstr(family_servings >= 10, "min_family_servings")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal}")
    print(f"Individual servings: {individual_servings.x}")
    print(f"Family servings: {family_servings.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

