
from gurobipy import *

# Create a model
m = Model("Soup_Kitchen_Optimization")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="individual_servings")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="family_servings")

# Set the objective function
m.setObjective(3*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(250*x1 + 1200*x2 <= 50000, "soup_limit")
m.addConstr(x1 >= 3*x2, "individual_vs_family")
m.addConstr(x2 >= 10, "family_servings_min")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Individual servings: {x1.x}")
    print(f"Family servings: {x2.x}")
    print(f"Maximum profit: ${3*x1.x + 10*x2.x}")
else:
    print("No optimal solution found")
