
import gurobi

def solve_soup_kitchen_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="individual_servings", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="family_servings", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 3*x1 + 10*x2
    model.setObjective(3*x1 + 10*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(250*x1 + 1200*x2 <= 50000, name="soup_limit")
    model.addConstr(x1 >= 3*x2, name="individual_to_family_ratio")
    model.addConstr(x2 >= 10, name="min_family_servings")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: individual servings = {x1.varValue}, family servings = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_soup_kitchen_problem()
