
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("supplement_optimization")

# Create variables
alpha = m.addVar(lb=0, name="alpha")  # scoops of Alpha
beta = m.addVar(lb=0, name="beta")  # scoops of Beta


# Set objective function: Minimize cost
m.setObjective(1 * alpha + 2 * beta, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * alpha + 10 * beta >= 50, "iron_req")  # Iron requirement
m.addConstr(20 * alpha + 3 * beta >= 40, "biotin_req") # Biotin requirement


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal}")
    print(f"Scoops of Alpha: {alpha.x}")
    print(f"Scoops of Beta: {beta.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

