
from gurobipy import *

# Create a new model
m = Model("Jane_Supplement_Problem")

# Define variables
x1 = m.addVar(name='Alpha_scoops', vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name='Beta_scoops', vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function to minimize cost
m.setObjective(1*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints for iron and biotin requirements
m.addConstr(5*x1 + 10*x2 >= 50, name='Iron_requirement')
m.addConstr(20*x1 + 3*x2 >= 40, name='Biotin_requirement')

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Alpha scoops: {x1.x}")
    print(f"Beta scoops: {x2.x}")
    print(f"Total cost: ${m.objVal}")
else:
    print("No optimal solution found")
