
import gurobipy as gp

# Create a new model
model = gp.Model("Iron_Biotin_Optimization")

# Define the variables
x1 = model.addVar(name="Alpha", lb=0)  # scoops of Alpha
x2 = model.addVar(name="Beta", lb=0)   # scoops of Beta

# Define the objective function
model.setObjective(1*x1 + 2*x2, gp.GRB.MINIMIZE)

# Define the constraints
model.addConstr(5*x1 + 10*x2 >= 50, name="Iron_Requirement")
model.addConstr(20*x1 + 3*x2 >= 40, name="Biotin_Requirement")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Scoops of Alpha: {x1.varValue}")
    print(f"Scoops of Beta: {x2.varValue}")
    print(f"Total Cost: {model.objVal}")
else:
    print("The model is infeasible or unbounded.")
