
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
milk_investment = m.addVar(name="milk_investment")
cheese_investment = m.addVar(name="cheese_investment")

# Set objective function
m.setObjective(0.08 * milk_investment + 0.06 * cheese_investment, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(milk_investment + cheese_investment <= 30000, "Total_investment")
m.addConstr(milk_investment >= 3 * cheese_investment, "Milk_cheese_ratio")
m.addConstr(milk_investment <= 25000, "Max_milk_investment")
m.addConstr(milk_investment >=0, 'non-negative milk')
m.addConstr(cheese_investment >=0, 'non-negative cheese')


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in milk industry: ${milk_investment.x}")
    print(f"Optimal investment in cheese industry: ${cheese_investment.x}")
    print(f"Maximum earnings: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

