
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Add variables
x1 = m.addVar(lb=0, name="amount_invested_milk")
x2 = m.addVar(lb=0, name="amount_invested_cheese")

# Set the objective function
m.setObjective(0.08*x1 + 0.06*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 == 30000, "total_investment")
m.addConstr(x1 >= 3*x2, "milk_at_least_three_times_cheese")
m.addConstr(x1 <= 25000, "max_milk_investment")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount invested in milk: {x1.x}")
    print(f"Amount invested in cheese: {x2.x}")
    print(f"Maximum earnings: {m.objVal}")
else:
    print("No optimal solution found")
