
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="milk_investment", lb=0)
    x2 = model.addVar(name="cheese_investment", lb=0)

    # Objective function: maximize 0.08*x1 + 0.06*x2
    model.setObjective(0.08*x1 + 0.06*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 30000, name="total_investment")
    model.addConstr(x1 >= 3*x2, name="milk_cheese_ratio")
    model.addConstr(x1 <= 25000, name="milk_investment_limit")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in milk industry: ${x1.varValue:.2f}")
        print(f"Optimal investment in cheese industry: ${x2.varValue:.2f}")
        print(f"Maximal earnings: ${0.08*x1.varValue + 0.06*x2.varValue:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
