
from gurobipy import Model, GRB

# Create a new model
m = Model("protein_bars")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Protein_Bar_A") # Allowing fractional bars for now
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Protein_Bar_B")

# Set objective function
m.setObjective(7*x1 + 10*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 >= 80, "Protein_Requirement")
m.addConstr(3*x1 + 5*x2 >= 50, "Fat_Requirement")
m.addConstr(11*x1 + 8*x2 >= 100, "Carb_Requirement")
m.addConstr(x1 >= 0)
m.addConstr(x2 >= 0)


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print(f"Number of Protein Bar A: {x1.x}")
    print(f"Number of Protein Bar B: {x2.x}")
    print(f"Minimum Cost: ${m.objVal}")

    # Round up to the nearest whole bar since we can't buy fractions of bars
    print("\nRounded up to the nearest whole bar:")
    print(f"Number of Protein Bar A: {int(x1.x + 0.9999)}")  # Add 0.9999 before int() to round up
    print(f"Number of Protein Bar B: {int(x2.x + 0.9999)}")
    rounded_cost = 7 * int(x1.x + 0.9999) + 10 * int(x2.x + 0.9999)
    print(f"Rounded Cost: ${rounded_cost}")

