
from gurobipy import *

# Create a new model
m = Model("Protein_Bars")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="x1", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2", lb=0)

# Set the objective function
m.setObjective(7*x1 + 10*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 >= 80, "protein")
m.addConstr(3*x1 + 5*x2 >= 50, "fat")
m.addConstr(11*x1 + 8*x2 >= 100, "carbs")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x1.x} of Protein Bar A")
    print(f"Buy {x2.x} of Protein Bar B")
    print(f"Total cost: ${7*x1.x + 10*x2.x}")
else:
    print("No optimal solution found")

