
import gurobipy as gp

# Create a new model
m = gp.Model("Bodybuilder_Nutrition")

# Define variables
x1 = m.addVar(name="Protein_Bar_A", lowBound=0, vtype=gp.GRB.INTEGER)  # Number of Protein Bar A
x2 = m.addVar(name="Protein_Bar_B", lowBound=0, vtype=gp.GRB.INTEGER)  # Number of Protein Bar B

# Objective function: minimize cost
m.setObjective(7 * x1 + 10 * x2, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(10 * x1 + 15 * x2 >= 80, name="protein_constraint")  # Protein constraint
m.addConstr(3 * x1 + 5 * x2 >= 50, name="fat_constraint")  # Fat constraint
m.addConstr(11 * x1 + 8 * x2 >= 100, name="carbs_constraint")  # Carbs constraint

# Solve the model
m.solve()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Minimum cost: ${7 * x1.varValue + 10 * x2.varValue}")
else:
    print("No optimal solution found.")
