
import gurobipy as gp

# Create a new model
m = gp.Model("Tropical_Farmer")

# Create variables
mangoes = m.addVar(lb=0, name="mangoes")  # Acres of mangoes
pineapples = m.addVar(lb=0, name="pineapples")  # Acres of pineapples


# Set objective function: Maximize profit
m.setObjective(400 * mangoes + 450 * pineapples, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(mangoes + pineapples <= 200, "Land_Constraint")  # Land constraint
m.addConstr(80 * mangoes + 100 * pineapples <= 18000, "Nutrient_Constraint")  # Nutrient constraint
m.addConstr(2 * mangoes + 1.5 * pineapples <= 350, "Picking_Constraint")  # Picking time constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Acres of Mangoes: {mangoes.x}")
    print(f"Acres of Pineapples: {pineapples.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

