
from gurobipy import *

# Create a model
m = Model("Tropical_Farmer")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_mangoes")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="acres_of_pineapples")

# Set the objective function
m.setObjective(400*x1 + 450*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(80*x1 + 100*x2 <= 18000, "nutrient_cost")
m.addConstr(2*x1 + 1.5*x2 <= 350, "picking_time")
m.addConstr(x1 + x2 <= 200, "total_land")
m.addConstr(x1 >= 0, "non_neg_mangoes")
m.addConstr(x2 >= 0, "non_neg_pineapples")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
