
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=0, name="mangoes")
    x2 = model.addVar(lb=0, name="pineapples")

    # Objective function: Maximize 400*x1 + 450*x2
    model.setObjective(400*x1 + 450*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 200, name="land_constraint")
    model.addConstr(80*x1 + 100*x2 <= 18000, name="nutrients_constraint")
    model.addConstr(2*x1 + 1.5*x2 <= 350, name="picking_time_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Acres of mangoes: {x1.varValue}")
        print(f"Acres of pineapples: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
