
import gurobipy as gp

# Create a new model
m = gp.Model("bus_ticket_optimization")

# Create variables
adult_tickets = m.addVar(vtype=gp.GRB.INTEGER, name="adult_tickets")
children_tickets = m.addVar(vtype=gp.GRB.INTEGER, name="children_tickets")

# Set objective function
m.setObjective(3 * adult_tickets + children_tickets, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(adult_tickets + children_tickets <= 80, "bus_capacity")
m.addConstr(children_tickets >= 15, "min_children_tickets")
m.addConstr(adult_tickets >= 3 * children_tickets, "adult_children_ratio")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of adult tickets: {adult_tickets.x}")
    print(f"Number of children's tickets: {children_tickets.x}")
    print(f"Maximum profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

