
from gurobipy import *

# Create a new model
m = Model("Bus_Ticket_Sales")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="adult_tickets")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="children_tickets")

# Set the objective function
m.setObjective(3*x1 + x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 80, "total_capacity")
m.addConstr(x2 >= 15, "children_reserved")
m.addConstr(x1 >= 3*x2, "adult_to_children_ratio")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Adult tickets: {x1.x}")
    print(f"Children tickets: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
