
import gurobi

def solve_bus_ticket_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="adult_tickets", lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="children_tickets", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 3*x1 + x2
    model.setObjective(3*x1 + x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 80, name="total_capacity")
    model.addConstr(x2 >= 15, name="children_tickets_reserved")
    model.addConstr(x1 >= 3*x2, name="adult_to_children_ratio")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: adult tickets = {x1.varValue}, children's tickets = {x2.varValue}")
    else:
        print("No optimal solution found")

solve_bus_ticket_problem()
