
import gurobipy as gp

# Create a new model
m = gp.Model("investment_optimization")

# Create variables
biotech = m.addVar(lb=0, name="biotech")
food = m.addVar(lb=0, name="food")
finance = m.addVar(lb=0, name="finance")
health_care = m.addVar(lb=0, name="health_care")


# Set objective function
m.setObjective(0.04 * biotech + 0.06 * food + 0.08 * finance + 0.10 * health_care, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(biotech + food + finance + health_care <= 1000000, "total_investment")
m.addConstr(health_care <= biotech, "health_care_biotech")
m.addConstr(food <= finance, "food_finance")
m.addConstr(health_care <= 0.30 * 1000000, "health_care_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Biotech investment: ${biotech.x:.2f}")
    print(f"Food investment: ${food.x:.2f}")
    print(f"Finance investment: ${finance.x:.2f}")
    print(f"Health care investment: ${health_care.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

