
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="biotech")
x2 = m.addVar(name="food")
x3 = m.addVar(name="finance")
x4 = m.addVar(name="health_care")

# Set the objective function
m.setObjective(0.04*x1 + 0.06*x2 + 0.08*x3 + 0.10*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x4 <= x1, name="health_care_vs_biotech")
m.addConstr(x2 <= x3, name="food_vs_finance")
m.addConstr(x4 <= 300000, name="max_health_care_investment")
m.addConstr(x1 + x2 + x3 + x4 == 1000000, name="total_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Biotech: {x1.x}")
    print(f"Food: {x2.x}")
    print(f"Finance: {x3.x}")
    print(f"Health Care: {x4.x}")
else:
    print("No optimal solution found")
