
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # biotech industry investment
    x2 = model.addVar(name='x2', lb=0)  # food industry investment
    x3 = model.addVar(name='x3', lb=0)  # finance industry investment
    x4 = model.addVar(name='x4', lb=0)  # health care industry investment

    # Objective function: maximize return on investment
    model.setObjective(0.04 * x1 + 0.06 * x2 + 0.08 * x3 + 0.10 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 + x3 + x4 <= 1000000)  # total investment
    model.addConstr(x4 <= x1)  # health care <= biotech
    model.addConstr(x2 <= x3)  # food <= finance
    model.addConstr(x4 <= 300000)  # health care <= 30% of total

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Biotech industry investment: ${x1.varValue:.2f}")
        print(f"Food industry investment: ${x2.varValue:.2f}")
        print(f"Finance industry investment: ${x3.varValue:.2f}")
        print(f"Health care industry investment: ${x4.varValue:.2f}")
        print(f"Total return on investment: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
