
import gurobipy as gp

# Create a new model
model = gp.Model("LeatherShop")

# Create variables
wallets = model.addVar(vtype=gp.GRB.INTEGER, name="wallets")
purses = model.addVar(vtype=gp.GRB.INTEGER, name="purses")

# Set objective function
model.setObjective(50 * wallets + 100 * purses, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10 * wallets + 15 * purses <= 500, "Cutting Time")
model.addConstr(20 * wallets + 30 * purses <= 600, "Stitching Time")
model.addConstr(wallets >= 0, "Non-negative wallets")  # Explicit non-negativity constraints
model.addConstr(purses >= 0, "Non-negative purses")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of wallets to make: {wallets.x}")
    print(f"Number of purses to make: {purses.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

