
from gurobipy import *

# Create a new model
m = Model("Leather_Shop_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="wallets", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="purses", lb=0)

# Set the objective function
m.setObjective(50*x1 + 100*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 500, "cutting_time")
m.addConstr(20*x1 + 30*x2 <= 600, "stitching_time")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of wallets: {x1.x}")
    print(f"Number of purses: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
